﻿using System;
using System.Runtime.InteropServices;
using System.Text;
using GTA;

// http://www.codeproject.com/Articles/1966/An-INI-file-handling-class-using-C
// Thanks to codeproject and BLaZiNiX

namespace NomeScripts
{
    /// <summary>
    /// Create a New INI file to store or load data
    /// </summary>
    public class IniFile
    {
        public string path;

        [DllImport("kernel32")]
        private static extern long WritePrivateProfileString(string section,
            string key, string val, string filePath);
        [DllImport("kernel32")]
        private static extern int GetPrivateProfileString(string section,
                 string key, string def, StringBuilder retVal,
            int size, string filePath);

        /// <summary>
        /// INIFile Constructor.
        /// </summary>
        /// <PARAM name="INIPath"></PARAM>
        public IniFile(string INIPath)
        {
            path = INIPath;
        }
        /// <summary>
        /// Write Data to the INI File
        /// </summary>
        /// <PARAM name="Section"></PARAM>
        /// Section name
        /// <PARAM name="Key"></PARAM>
        /// Key Name
        /// <PARAM name="Value"></PARAM>
        /// Value Name
        public void IniWriteValue(string Section, string Key, string Value)
        {
            WritePrivateProfileString(Section, Key, Value, this.path);
        }

        /// <summary>
        /// Read Data Value From the Ini File
        /// </summary>
        /// <PARAM name="Section"></PARAM>
        /// <PARAM name="Key"></PARAM>
        /// <returns></returns>
        public string IniReadValue(string Section, string Key)
        {
            StringBuilder temp = new StringBuilder(255);
            int i = GetPrivateProfileString(Section, Key, "", temp, 255, this.path);
            return temp.ToString();
        }

        public bool GetValueFromIni(ref float value, String section, String key)
        {
            try
            {
                value = float.Parse(this.IniReadValue(section, key));
            }
            catch (ArgumentNullException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }
            catch (FormatException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }
            catch (OverflowException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }

            return true;
        }

        public bool GetValueFromIni(ref int value, String section, String key)
        {
            try
            {
                value = Int32.Parse(this.IniReadValue(section, key));
            }
            catch (ArgumentNullException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }
            catch (FormatException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }
            catch (OverflowException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }

            return true;
        }

        public bool GetValueFromIni(ref bool value, String section, String key)
        {
            try
            {
                value = bool.Parse(this.IniReadValue(section, key));
            }
            catch (ArgumentNullException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }
            catch (FormatException)
            {
                Game.Console.Print(key + " value in ini file is invalid.");
                return false;
            }

            return true;
        }
    }
}
